@echo off
setlocal enabledelayedexpansion

REM Check if the script has administrator privileges
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"

REM If not has administrator privileges, re-run the script with administrator privileges
if '%errorlevel%' NEQ '0' (
    echo Requesting administrator privileges...
    goto UACPrompt
) else ( goto gotAdmin )

:UACPrompt
    echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
    echo UAC.ShellExecute "%~s0", "", "", "runas", 1 >> "%temp%\getadmin.vbs"
    "%temp%\getadmin.vbs"
    del "%temp%\getadmin.vbs"
    exit /B

:gotAdmin
    pushd "%CD%"
    CD /D "%~dp0"

REM Main scripts

REM Get the current script directory (full long path)
for /f "delims=" %%i in ('powershell -NoProfile -Command "(Get-Item '%~dp0').FullName"') do set "SCRIPT_DIR=%%i"
REM Remove trailing backslash for compatibility
REM if "%SCRIPT_DIR:~-1%"=="\" set "SCRIPT_DIR=%SCRIPT_DIR:~0,-1%"

set "PS_SCRIPT=%SCRIPT_DIR%find_vid_pid.ps1"

set SERVICE_NAME=BioInitService

:searchagain

REM stop service
sc stop %SERVICE_NAME%

REM Call PowerShell script to find OEM INF files
echo Searching for OEM INF files...
for /f "usebackq delims=" %%F in (`powershell -NoProfile -ExecutionPolicy Bypass -File "%PS_SCRIPT%"`) do (
    set "OEMFILE=%%F"
    goto found
)

goto :notfound

:found
echo OEM INF file: !OEMFILE!
"%SCRIPT_DIR%\DriverUtil.exe" deleteoem !OEMFILE!
timeout /t 1 /nobreak >nul
"%SCRIPT_DIR%\devcon.exe" rescan
timeout /t 3 /nobreak >nul
goto :searchagain

:notfound
echo uninstall finished

:end

REM Check if the first argument is not 1, then pause
if "%1" NEQ "1" (
    pause
)

